# 画面設計書 14-OPFS VFS テスト

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるOPFS VFS テスト画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、OPFS（Origin Private File System）を使用したsqlite3_vfsのサニティテスト（健全性検証）を実行するためのテストページである。

**業務上の目的・背景**：SQLite WASMビルドにおいて、OPFSはブラウザ上での永続的なファイルストレージを提供する重要なVFS実装である。本画面は、OPFS VFSが正しく動作することを検証するためのサニティテストを提供し、永続データベースの作成・読み取り・更新、およびOPFSユーティリティ関数（mkdir、unlink、entryExistsなど）の動作確認を行う。SharedArrayBufferとAtomics APIを使用した同期処理の検証も含まれる。

**画面へのアクセス方法**：インデックスページ（index.html）の「OPFS Test」リンクからアクセスするか、直接 `test-opfs-vfs.html` にアクセスする。COOP/COEPヘッダーが必要。

**主要な操作・処理内容**：
1. ページ読み込み時にWorkerスレッドを起動し、test-opfs-vfs.jsをロード
2. OPFSが利用可能か確認し、'opfs' VFSを取得
3. 永続データベース（my-persistent.db）を作成または開く
4. テーブル作成・データ挿入・クエリ実行のテスト
5. OPFSユーティリティ関数（mkdir, unlink, entryExists）の動作検証
6. 結果を開発者コンソールに出力

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）
- 特殊リンク: `?delete`パラメータで既存DBを削除

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | OPFS VFS用sqlite3モジュール初期化 |
| 43 | OS抽象化層（VFS） | 主機能 | OPFS sqlite3_vfsの動作確認テスト |
| 42 | ミューテックス | 補助機能 | SharedArrayBuffer・Atomics APIでの同期処理 |

## 画面種別

テスト実行画面（結果は開発者コンソールに出力）

## URL/ルーティング

```
/ext/wasm/test-opfs-vfs.html
/ext/wasm/test-opfs-vfs.html?delete  # 既存DBを削除
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| delete | 入力 | URLパラメータ | 任意 | 存在時は既存の永続DBを削除 |
| コンソール出力 | 出力 | text | - | テスト実行ログと結果 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトルバー | "Async-behind-Sync sqlite3_vfs" | 常時表示 |
| 説明テキスト | OPFSサニティテストの説明 | 常時表示 |
| 開発者コンソール案内 | 出力は開発者コンソールで確認する旨 | 常時表示 |
| 削除リンク | "Use this link"でDBを削除 | 常時表示 |
| テスト出力エリア | 空（結果はコンソール） | 常時 |

## イベント仕様

### 1-ページ読み込み

1. Workerを生成し、test-opfs-vfs.jsをロード
2. URLパラメータをWorkerに渡す（?delete含む）

### 2-Worker内テスト実行

1. sqlite3InitModuleでモジュール初期化
2. tryOpfsVfs関数でテスト実行:
   - OPFSの利用可能性確認
   - 'opfs' VFSの取得と検証
   - ?delete時は既存DBを削除
   - OpfsDb でデータベース作成/開く
   - テーブル作成・データ挿入
   - SELECT COUNT(*)でデータ確認
   - mkdir/unlink/entryExistsのテスト

### 3-DB削除リンククリック

- `?delete`パラメータ付きでページリロード
- Worker内でsqlite3.opfs.unlink(dbFile)が実行される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テスト実行 | t | INSERT/SELECT | テストデータの挿入とカウント取得 |

### テーブル別更新項目詳細

#### t テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE | a | - | CREATE TABLE IF NOT EXISTS t(a) |
| INSERT | a | performance.now()の値（3件） | トランザクション内で実行 |
| SELECT | - | count(*) | データ件数確認 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "tryOpfsVfs()" | テスト開始時 |
| MSG002 | エラー | "OPFS is not available." | OPFS非対応時 |
| MSG003 | 情報 | "OPFS VFS: {pVfs} {oVfs}" | VFS取得成功時 |
| MSG004 | 情報 | "db file: {filename}" | DB作成/オープン成功時 |
| MSG005 | 情報 | "Persistent data found. sqlite_schema entry count = {n}" | 既存データ発見時 |
| MSG006 | 情報 | "count(*) from t = {n}" | SELECTカウント結果 |
| MSG007 | 情報 | "Done!" | テスト完了時 |
| MSG008 | エラー | "Error initializing module: {e}" | モジュール初期化失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| OPFS非対応環境 | Errorをスロー、エラーメッセージ出力 |
| 'opfs' VFS未登録 | toss("Missing 'opfs' VFS.")でエラー |
| mkdir失敗 | toss("mkdir failed")でエラー |
| ディレクトリ削除の不整合 | tossで詳細エラー |
| モジュール初期化失敗 | console.errorでエラー出力 |

## 備考

- 結果はすべて開発者コンソールに出力される
- SharedArrayBufferが必要なためCOOP/COEPヘッダーが必須
- テスト用の一時ディレクトリは自動的にクリーンアップされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OPFS APIとsqlite3オブジェクトの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | test-opfs-vfs.js | `ext/wasm/test-opfs-vfs.js` | sqlite3.opfsオブジェクトとOpfsDbクラス |

**読解のコツ**: sqlite3.opfsはOPFS操作のユーティリティを提供。OpfsDbはoo1.DBの拡張でOPFS永続化対応。

#### Step 2: エントリーポイントを理解する

HTMLファイルでのWorker起動。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | test-opfs-vfs.html | `ext/wasm/test-opfs-vfs.html` | Worker生成とURLパラメータ連携 |

**主要処理フロー**:
1. **行20-24**: Worker生成時にsqlite3.dirとURLパラメータを渡す

#### Step 3: テスト処理を理解する

Worker内でのOPFSテストロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | test-opfs-vfs.js | `ext/wasm/test-opfs-vfs.js` | tryOpfsVfs関数の詳細 |

**主要処理フロー**:
- **行16-78**: tryOpfsVfs関数
- **行22-28**: OPFS利用可能性チェック
- **行30-31**: 'opfs' VFSの取得と検証
- **行40**: ?delete時のunlink処理
- **行42**: OpfsDbインスタンス作成
- **行44-60**: テーブル作成とデータ挿入
- **行63-72**: OPFSユーティリティ関数テスト
- **行80-85**: モジュール初期化とテスト実行

### プログラム呼び出し階層図

```
test-opfs-vfs.html
    │
    └─ new Worker('test-opfs-vfs.js')
           │
           ├─ importScripts('jswasm/sqlite3.js')
           │
           └─ sqlite3InitModule()
                  │
                  └─ tryOpfsVfs(sqlite3)
                         │
                         ├─ sqlite3_vfs_find("opfs")
                         │
                         ├─ sqlite3.opfs.unlink() [?delete時]
                         │
                         ├─ new sqlite3.oo1.OpfsDb(dbFile)
                         │      └─ db.transaction() → db.exec()
                         │
                         ├─ opfs.mkdir() / opfs.unlink()
                         │
                         └─ db.close()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ─────▶ Worker (test-opfs-vfs.js) ─────▶ console.log/error
(?delete)              │
                       ├─ OPFS VFS取得
                       │
                       ├─ OpfsDb操作
                       │      ├─ CREATE TABLE
                       │      ├─ INSERT
                       │      └─ SELECT COUNT
                       │
                       └─ OPFSユーティリティテスト
                              ├─ mkdir
                              ├─ unlink
                              └─ entryExists
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| test-opfs-vfs.html | `ext/wasm/test-opfs-vfs.html` | テンプレート | メイン画面HTML |
| test-opfs-vfs.js | `ext/wasm/test-opfs-vfs.js` | ソース | OPFSテストWorkerスクリプト |
| sqlite3.js | `ext/wasm/jswasm/sqlite3.js` | ソース | sqlite3 WASMモジュール |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
